<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class MailNotification extends Mailable
{
    use Queueable, SerializesModels;
    public $content;
    public $route;
    public $subjectEmail;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($content,$route,$subjectEmail)
    {
        $this->content = $content;
        $this->route = $route;
        $this->subjectEmail = $subjectEmail;
    }

   
    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */
    public function envelope()
    {
        return new Envelope(
            subject:$this->subjectEmail,
        );
    }

    /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */
    public function content()
    {
        return new Content(
            view: 'mail.email-notification',
            with: [
                'content' => $this->content,
                'route' => $this->route,
            ],
        );
    }

    // /**
    //  * Get the attachments for the message.
    //  *
    //  * @return array
    //  */
    // public function attachments()
    // {
    //     return [];
    // }
}
